/***************************************************************************
 *cr                                                                       
 *cr            (C) Copyright 1995 The Board of Trustees of the           
 *cr                        University of Illinois                       
 *cr                         All Rights Reserved                        
 *cr                                                                   
 ***************************************************************************/

/***************************************************************************
 * RCS INFORMATION:
 *
 *	$RCSfile: Global.h,v $
 *	$Author: dalke $	$Locker:  $		$State: Exp $
 *	$Revision: 1.20 $	$Date: 1995/05/15 09:21:38 $
 *
 ***************************************************************************
 * DESCRIPTION:
 *
 * Global data structures, configuration settings, and macros for the 
 * vmd library.
 *
 ***************************************************************************/
#ifndef GLOBAL_DEFS_H
#define GLOBAL_DEFS_H

// standard includes for all modules
#include "utilities.h"
#include "config.h"
#include "Inform.h"

// the name of this program, and temp directory to use
extern char *myName;
extern char *myPath;
extern char *myTempDir;
extern char *dataPath;

// location of the Babel executable (or NULL)
extern char *vmdBabelBin;

// name of the HTML viewer to use (or NULL if none)
extern char *vmdHTMLViewer;

// display device in which the images are rendered
class DisplayDevice;
extern DisplayDevice *display;

// the list of all Displayable objects to draw
class Scene;
extern Scene *scene;

// the list of all Lights which should be drawn
class LightList;
extern LightList *lights;

// the list of all color objects (including material definitions)
class ColorList;
extern ColorList *colors;

// axes and stage used in the scene
class Axes;
extern Axes *axes;
class Stage;
extern Stage *stage;

// the command processor
class CommandQueue;
extern CommandQueue *commandQueue;

// collection of all user interface objects
class UIList;
extern UIList *uiList;

// the text interface
class UIText;
extern UIText *uiText;

// the mouse used to manipulate the objects
class Mouse;
extern Mouse *mouse;

// the global lists of all tools and trackers in maintained in UIVR
class UIVR;
extern UIVR *uiVR;

// the global list of all molecules
class MoleculeList;
extern MoleculeList *moleculeList;

// the global list of geometry labels
class GeometryList;
extern GeometryList *geometryList;

// the atom selection parser
class SymbolTable;
extern SymbolTable atomSelParser;
void atomSelParser_init(void);

// current remote setup object (only one is active at a time), and list of
// running simulations
#ifdef VMDREMOTE
class Remote;
extern Remote *remote;
class RemoteList;
extern RemoteList *remoteList;
#endif

// this allow text commands to be sent in via PVM messages
#ifdef VMDEXTERNAL
class UIExternal;
extern UIExternal *uiExternal;
#endif

// resource to hold configuration values from a file
class ConfigList;
extern ConfigList *configList;

// the different ways to record a scene to a file in some format
class FileRenderList;
extern FileRenderList *fileRenderList;

/////////////////////////  external functions  

// initialize the global variables and objects for the general library.
// Must be passed command-line arguments to program.  Creates graphics
// context and all associated objects, and then starts the UI, then adds any
// commands that should be done at start.  When done, flushes command queue
// and then returns, when the program is ready to start main event loop.
extern void VMDinit(int, char *[]);

// initialize the user interface ... called by VMDinit at start
extern void VMDinitUI(void);

// print out title message
extern void VMDtitle(void);

// given a string, return a new one with the temp dir name prepended.
// This will use an internal static buffer, so it is NOT reentrant.
extern char *VMDtempFile(const char *);

// given a string, start up a HTML viewer with the string as an argument.
// Return success.
extern int VMDreadHTML(char *);

// redraw the screen and update all things that need updatin'
extern int VMDupdate(int);

// exit the program normally with a message and exit code
extern void VMDexit(char *, int);

// exit the program abnormally with a message
extern void VMDdie(char *);

#endif

