/***************************************************************************
 *cr                                                                       
 *cr            (C) Copyright 1995 The Board of Trustees of the           
 *cr                        University of Illinois                       
 *cr                         All Rights Reserved                        
 *cr                                                                   
 ***************************************************************************/

/***************************************************************************
 * RCS INFORMATION:
 *
 *	$RCSfile: GraphicsFormsObj.h,v $
 *	$Author: dalke $	$Locker:  $		$State: Exp $
 *	$Revision: 1.6 $	$Date: 1995/05/18 23:31:10 $
 *
 ***************************************************************************
 * DESCRIPTION:
 *
 * The on-screen menu to control the coloring and display method of molecules.
 *
 ***************************************************************************/
#ifndef GRAPHICSFORMSOBJ_H
#define GRAPHICSFORMSOBJ_H

#include "FormsObj.h"
#include "Molecule.h"


class GraphicsFormsObj : public FormsObj {

private:
  // which molecule ID we are working with, and pointer to this molecule
  int molID;
  Molecule *dmol;
  
  // which representation of the current molecule is being edited. If < 0,
  // none are.  If more than one is being editing, this is the smallest
  // number in the list.
  int molRep;

  // current mode of editing for the menu ...
  int editMode;

  // returns a char * describing the mth rep of the current mol.  
  // It uses the passed in buffer for storage space.  If there
  // is an error, the string is returned empty (ie, [0] = 0 ( == "")).
  char *graphics_rep_string(int m, char *buffer);
  
  // set the graphics editing mode to the given value
  void set_editing_mode(int);

  // fill the namelist browser for atom selection with the proper names
  void reset_namelist_browser(void);

  // fill the graphics rep browser with the settings for the current mol
  void fill_graphics_reps_browser(void);

  // reset the form to use the molecule with given ID as the current mol
  void reset_edited_molecule(int);
  
  // reset the form based on the current selections in the graphics rep browser
  void reset_edited_rep(void);

  // reset coloring method controls based on current rep, if any
  // Argument is a flag for whether the values of the data items should be
  // changed.
  void reset_coloring_method(int);
  
  // reset drawing method controls based on current rep, if any
  // Argument is a flag for whether the values of the data items should be
  // changed.
  void reset_drawing_method(int);
  
  // reset atom selection controls based on current rep, if any
  // Argument is a flag for whether the values of the data items should be
  // changed.
  void reset_selection_method(int);

  // fill string with text command to set objects to proper color, rep, or sel
  char *create_color_cmd(void);
  char *create_rep_cmd(void);
  char *create_sel_cmd(void);

  // returns a (internally stored) string with the selection command
  // text that corresponds to the given index
  const char *selection_command(int index);
  // returns the number of possible selection commands
  int num_selection_commands(void);

protected:
  // check if the given forms pointer is one for this menu, and generate
  // a command if necessary.  Return 'TRUE' if the pointer is for an object
  // in this menu.
  virtual int check(FL_OBJECT *);

  // do form-specific acting on commands
  virtual int forms_act_on_command(int, Command *, int);

public:
  // class constructor and destructor
  GraphicsFormsObj(UIList *, CommandQueue *, int, int, int * = NULL);

  //
  // virtual routines for UI init/display
  //
  
  // initialize the user interface
  virtual void init(void);
  
  // reset the user interface (forces update of all info displays)
  virtual void reset(void);

};

#endif

