/***************************************************************************
 *cr                                                                       
 *cr            (C) Copyright 1995 The Board of Trustees of the           
 *cr                        University of Illinois                       
 *cr                         All Rights Reserved                        
 *cr                                                                   
 ***************************************************************************/

/***************************************************************************
 * RCS INFORMATION:
 *
 *	$RCSfile: Grid.h,v $
 *	$Author: billh $	$Locker:  $		$State: Exp $
 *	$Revision: 1.3 $	$Date: 1995/05/11 22:59:22 $
 *
 ***************************************************************************
 * DESCRIPTION:
 *   Simple template to hold a grid of data
 *
 ***************************************************************************/
#ifndef GRID_TEMPLATE_H
#define GRID_TEMPLATE_H

// This is an nx, ny, nz grid of <T> values.  That is all.
// It cannot be extended or shrunk, though you could undoubtably
// make a ResizeGrid if needed


template<class T>
class Grid {
 private:
   int nx, ny, nz;
   T*** data;
 public:
   Grid(int numx, int numy, int numz);
   ~Grid(void);

   T** operator[](int x) { return data[x];}
   T& item(int x, int y, int z) {
      return data[x][y][z];
   }
   void numrange(int *x, int *y, int *z){
      *x = nx; *y = ny; *z = nz;
   }
};

#endif

