/***************************************************************************
 *cr                                                                       
 *cr            (C) Copyright 1995 The Board of Trustees of the           
 *cr                        University of Illinois                       
 *cr                         All Rights Reserved                        
 *cr                                                                   
 ***************************************************************************/

/***************************************************************************
 * RCS INFORMATION:
 *
 *	$RCSfile: LightList.C,v $
 *	$Author: billh $	$Locker:  $		$State: Exp $
 *	$Revision: 1.4 $	$Date: 1995/05/11 23:02:01 $
 *
 ***************************************************************************
 * DESCRIPTION:
 *
 * A list of Light objects; used to select a single active one and allow
 * the user to manipulate it.  Also provides an initial set of default lights.
 *
 ***************************************************************************/

#include "LightList.h"
#include "Light.h"
#include "Scene.h"
#include "Matrix4.h"
#include "Inform.h"

// default light data
static float def_light_color[3] = { 1.0, 1.0, 1.0 };
static float def_light_pos[MAX_DISP_LIGHTS][3] = { 
	{ -0.1, 0.1, 1.0 }, { 1.0, 2.0, 0.5 },
	{ -1.0, 2.0, -1.0 }, { -1.0, -1.0, 0.0 }
};


// constructor: create lights with default values, and add to self
LightList::LightList(Scene *sc) {

  // set the number of lights to have in this list
  numLights = MAX_DISP_LIGHTS;

  MSGDEBUG(1,"Creating LightList, with " << numLights << " lights.");
  MSGDEBUG(1,sendmsg);

  // create lights, with default values
  for(int i=0; i < numLights; i++)
    ltList[i] = new Light(sc, i, def_light_color, def_light_pos[i]);

  // make light 0 the current light
  reset();
}


// destructor: delete lights in list
LightList::~LightList(void) {
  MSGDEBUG(1,"Deleting LightList, with " << numLights << " lights.");
  MSGDEBUG(1,sendmsg);

  for(int i=0; i < numLights; i++)
    delete ltList[i];
}


// apply rotations to the current light, if any
void LightList::add_rot(float x, char axis) {
  if(!is_current())
    return;
    
  current() ->add_rotation(x, axis);
}

// apply rotations to the current light, if any
void LightList::add_rot(Matrix4 &m) {
  if(!is_current())
    return;
    
  current() ->add_rotation(m);
}

// apply rotations to the current light, if any
void LightList::set_rot(Matrix4 &m) {
  if(!is_current())
    return;
    
  current() ->set_rotation(m);
}

