/***************************************************************************
 *cr                                                                       
 *cr            (C) Copyright 1995 The Board of Trustees of the           
 *cr                        University of Illinois                       
 *cr                         All Rights Reserved                        
 *cr                                                                   
 ***************************************************************************/

/***************************************************************************
 * RCS INFORMATION:
 *
 *	$RCSfile: MolAction.h,v $
 *	$Author: billh $	$Locker:  $		$State: Exp $
 *	$Revision: 1.3 $	$Date: 1995/05/11 23:18:03 $
 *
 ***************************************************************************
 * DESCRIPTION:
 *
 * A MolAction object is something which performs an 'act' for a Molecule
 * object.  For example, it may change the bond radius or display all
 * alpha carbons.  It is used by the MoleculeList object to perform an
 * action on a list of objects.
 *
 ***************************************************************************/
#ifndef MOLACTION_H
#define MOLACTION_H

#include "Molecule.h"


// defines for setting the current frame to the beginning or end
#define SET_FRAME_START		(-1)
#define SET_FRAME_END		(-2)


////////////////////////////  MolAction base class  \\\\\\\\\\\\\\\\\\\

class MolAction {

public:
  MolAction(void) { }
  virtual ~MolAction(void);

  // virtual routine which each subclass replaces with the particular action
  // they want done
  virtual void act(Molecule *) = 0;

};

////////////////////////////  inherited MolAction classes  \\\\\\\\\\\\\\\\\\\

// MolPause
class MolPause : public MolAction {
public:
  MolPause(void) { }
  virtual void act(Molecule *);
};

// MolReverse
class MolReverse : public MolAction {
public:
  MolReverse(void) { }
  virtual void act(Molecule *);
};

// MolReverse1
class MolReverse1 : public MolAction {
public:
  MolReverse1(void) { }
  virtual void act(Molecule *);
};

// MolForward
class MolForward : public MolAction {
public:
  MolForward(void) { }
  virtual void act(Molecule *);
};

// MolForward1
class MolForward1 : public MolAction {
public:
  MolForward1(void) { }
  virtual void act(Molecule *);
};

// MolSetFrame
class MolSetFrame : public MolAction {
private:
  int val;
public:
  MolSetFrame(int s) { val = s; }
  virtual void act(Molecule *);
};

// MolSetSkip
class MolSetSkip : public MolAction {
private:
  int val;
public:
  MolSetSkip(int s) { val = s; }
  virtual void act(Molecule *);
};

// MolAnimStyle
class MolAnimStyle : public MolAction {
private:
  Animation::AnimStyle newstyle;
public:
  MolAnimStyle(Animation::AnimStyle ns) { newstyle = ns; }
  virtual void act(Molecule *);
};

// MolSetSpeed
class MolSetSpeed : public MolAction {
private:
  float speed;
public:
  MolSetSpeed(float s) { speed = s; }
  virtual void act(Molecule *);
};


#endif

