/***************************************************************************
 *cr                                                                       
 *cr            (C) Copyright 1995 The Board of Trustees of the           
 *cr                        University of Illinois                       
 *cr                         All Rights Reserved                        
 *cr                                                                   
 ***************************************************************************/

/***************************************************************************
 * RCS INFORMATION:
 *
 *	$RCSfile: MoleculeFile.C,v $
 *	$Author: billh $	$Locker:  $		$State: Exp $
 *	$Revision: 1.8 $	$Date: 1995/05/11 23:18:08 $
 *
 ***************************************************************************
 * DESCRIPTION:
 *
 * A MoleculeFile is inherited from Molecule, and supplies routines to 
 * create a molecule by reading data from a file.
 *
 ***************************************************************************/

#include <math.h>
#include <string.h>
#include <ctype.h>
#include "MoleculeFile.h"
#include "Atom.h"
#include "utilities.h"


// string file extensions for the different known structure files
char *structureFileTypeNames[MoleculeFile::STRTYPES] = {
	"psf", "pdb", "edm", "graph", "raster3d",

	"Alchemy", "AMBERPREP", "BallStick", "BiosymCAR", "Boogie",
"Cacao", "CADPAC", "CHARMm", "Chem3d-1", "Chem3d-2", "CSSR", "FDAT",
"GSTAT", "Feature", "Fractional", "GAMESSoutput", "Z-matrix",
"Gaussianoutput", "HIN", "Isis", "MacMolecule", "Macromodel",
"MicroWorld", "MM2Input", "MM2Output", "MM3", "MMADS", "MDLMOL",
"MOLIN", "MopacCartesian", "MopacInternal", "MopacOutput", "PCModel",
"Quanta", "ShelX", "Spartan", "SpartanSE", "SpartanMM", "Sybyl",
"Sybyl2", "Conjure", "Maccs2d", "Maccs3d", "UniChemXYZ", "XYZ", "XED"
};


/////////////////////////////////////////////////////////////////////
// class constructor ... specifies the filename and either,
// a Scene or Displayable
MoleculeFile::MoleculeFile(char *fname, Scene *sc) : Molecule("File", sc) {
  do_construct(fname);
}

// this version uses a Displayable instead of Scene, so that it becomes a
// child Displayable to some parent.
MoleculeFile::MoleculeFile( char *fname, Displayable *dp) :
        Molecule("File", dp) {
  do_construct(fname);
}


///////////////////////// destructor
MoleculeFile::~MoleculeFile(void) {
  MSGDEBUG(1,"Deleting MoleculeFile ..." << sendmsg);

  delete [] strFile;
  delete [] strPath;
  delete [] strName;
}


// do main constructor tasks
void MoleculeFile::do_construct( char *fname) {
  strFile = stringdup(fname);
  breakup_filename(strFile, &strPath, &strName);
  if(!strPath)
    strPath = stringdup("");
  if(!strName)
    strName = stringdup("unknown");  
  MSGDEBUG(1,"Creating MoleculeFile, file='" << fname << "'");
}


// creates the molecule, using the info provided in the constructor.
// returns success, and also calls parent class create routines
int MoleculeFile::create(void) {

  // set the file name as the molecule's name
  set_name(strName);

  return Molecule::create();
}


// return the path of this molecule
char *MoleculeFile::file_path(void) {
  return strPath;
}


// return the name of this molecule
char *MoleculeFile::file_name(void) {
  return strName;
}

