/***************************************************************************
 *cr                                                                       
 *cr            (C) Copyright 1995 The Board of Trustees of the           
 *cr                        University of Illinois                       
 *cr                         All Rights Reserved                        
 *cr                                                                   
 ***************************************************************************/

/***************************************************************************
 * RCS INFORMATION:
 *
 *	$RCSfile: MoleculeFile.h,v $
 *	$Author: billh $	$Locker:  $		$State: Exp $
 *	$Revision: 1.7 $	$Date: 1995/05/11 23:18:09 $
 *
 ***************************************************************************
 * DESCRIPTION:
 *
 * A MoleculeFile is inherited from Molecule, and supplies routines to 
 * create a molecule by reading data from a file.
 *
 ***************************************************************************/
#ifndef MOLECULEFILE_H
#define MOLECULEFILE_H

#include "Molecule.h"


class MoleculeFile : public Molecule {

public:
  // ways to read structure ... character names are in the array declared
  // at the bottom of this file.
  enum StructureFile { PSF, PDB, EDM, GRAPH, RASTER3D,
     T, PREP, BS, CAR, BOOG, CACCRT, CADPAC, CHARMM, C3D1, C3D2, CSSR, 
     FDAT, C, FEAT, F, GAMOUT, G, GAUOUT, HIN, ISIS, MACMOL, K, MICRO, 
     MI, MO, MM3, MMADS, MDL, MOLEN, AC, AI, AO, PC, QUANTA, SHELX, 
     SPAR, SEMI, SPMM, MOL, MOL2, CON, MACCS2, MACCS3, UNIXYZ, X, XED, 
		       STRTYPES, UNKNOWN };

protected:
  // name of path and filename containing structure of molecule
  char *strFile, *strPath, *strName;

  // this extracts the filename
  // and inits some data
  void do_construct(char *filename);

public:
  //  class constructor/destructor
  MoleculeFile(char *filename, Scene *);
  MoleculeFile(char *filename, Displayable *);
  virtual ~MoleculeFile(void);

  // creates the molecule, using the info provided in the constructor.
  // returns success, and also calls parent class create routines
  virtual int create(void);

  // return the path and name of this molecule
  virtual char *file_path(void);
  virtual char *file_name(void);

};

// string names for the different structure file types (identified by
// their file extension)
extern char *structureFileTypeNames[MoleculeFile::STRTYPES];

#endif

