/***************************************************************************
 *cr                                                                       
 *cr            (C) Copyright 1995 The Board of Trustees of the           
 *cr                        University of Illinois                       
 *cr                         All Rights Reserved                        
 *cr                                                                   
 ***************************************************************************/

/***************************************************************************
 * RCS INFORMATION:
 *
 *	$RCSfile: MoleculeFileGraph.h,v $
 *	$Author: billh $	$Locker:  $		$State: Exp $
 *	$Revision: 1.3 $	$Date: 1995/05/11 23:18:13 $
 *
 ***************************************************************************
 * DESCRIPTION:
 *   Read in (x,y,z) from a file to plot 2d scalar graphs
 * 
 ***************************************************************************/
#ifndef MOLECULEFILEGRAPH_H
#define MOLECULEFILEGRAPH_H

// the input format is
// minx maxx miny maxy nx ny
// data(0,0)
// data(0,1)
// ...
// data(0,ny-1)
// data(1,0)
// ...
// data(nx-1, ny-1)

// (the info can be on the same line -- whitespace delimited)

#include "MoleculeFile.h"
#include "Grid.h" // but only used for 2D (with numz = 1)

class MoleculeFileGraph : public MoleculeFile
{
 private:
   // read in the (x,y,z) info and store in local space
   Grid<float> *grid;
   float minx, miny, minz, maxx, maxy, maxz;
   float mindata, maxdata;
 public:
   MoleculeFileGraph(char *filename, Scene *);
   MoleculeFileGraph(char *filename, Displayable *);
   virtual ~MoleculeFileGraph(void);

   // creates the molecule, calls the parent's create, and returns success
   virtual int create(void);
   virtual void create_cmdlist(void);

   // functions to "normalize" the picture  -- for a centering
   // translation and a scaling;
   virtual void cov(float &x, float &y, float &z);
   virtual float scale_factor(void);
};

#endif

