/***************************************************************************
 *cr                                                                       
 *cr            (C) Copyright 1995 The Board of Trustees of the           
 *cr                        University of Illinois                       
 *cr                         All Rights Reserved                        
 *cr                                                                   
 ***************************************************************************/

/***************************************************************************
 * RCS INFORMATION:
 *
 *	$RCSfile: MoleculeFileRaster3D.h,v $
 *	$Author: billh $	$Locker:  $		$State: Exp $
 *	$Revision: 1.3 $	$Date: 1995/05/11 23:18:18 $
 *
 ***************************************************************************
 * DESCRIPTION:
 *   read in from a Raster3D data file
 *
 ***************************************************************************/
#ifndef MOLECULEFILERaster3D_H
#define MOLECULEFILERaster3D_H

// All this does is read the data into the rendering command list
// there is no way to change anything -- maybe in the future?

#include "MoleculeFile.h"


class MoleculeFileRaster3D : public MoleculeFile
{
 private:
   // I don't have to save anything since I cannot
   // yet manipulate the objects
   
   float minx, miny, minz, maxx, maxy, maxz;
 public:
   MoleculeFileRaster3D(char *filename, Scene *);
   MoleculeFileRaster3D(char *filename, Displayable *);
   virtual ~MoleculeFileRaster3D(void);

   // create the molecule and calls the parents
   virtual int create(void);

   // center of volume, and scaling factor
   virtual void cov(float &x, float &y, float&z);
   virtual float scale_factor(void);
};

#endif

