/***************************************************************************
 *cr                                                                       
 *cr            (C) Copyright 1995 The Board of Trustees of the           
 *cr                        University of Illinois                       
 *cr                         All Rights Reserved                        
 *cr                                                                   
 ***************************************************************************/

/***************************************************************************
 * RCS INFORMATION:
 *
 *	$RCSfile: POVDisplayDevice.h,v $
 *	$Author: khamer $	$Locker:  $		$State: Exp $
 *	$Revision: 1.1 $	$Date: 1995/05/16 20:31:28 $
 *
 ***************************************************************************
 * DESCRIPTION:
 *
 * FileRenderer type for the Persistence of Vision raytracer
 *
 ***************************************************************************/
#ifndef POVDISPLAYDEVICE
#define POVDISPLAYDEVICE

#include <stdio.h>
#include "FileRenderer.h"


class POVDisplayDevice : public FileRenderer {

private:

  // output file pointer
  FILE *pov_file;
  
  // output file name
  char *pov_filename;
  
  // was the file created?
  int Initialized;

protected:

  //
  // assorted graphics functions
  //
  
  void point(float *);
  void sphere(float *);
  void line(float *, float *);
  void cylinder(float *, float *, float);
  void cone(float *, float *, float); 
  void triangle(float *, float *, float *, float *, float *, float *);
  void square(float *, float *, float *, float *, float *);
   
public: 
  // constructor/destructor

  POVDisplayDevice(char *);
  virtual ~POVDisplayDevice(void);
  
  virtual void prepare3D(int = TRUE);
  virtual void update(int = TRUE);
  
}; 

#endif
