/***************************************************************************
 *cr                                                                       
 *cr            (C) Copyright 1995 The Board of Trustees of the           
 *cr                        University of Illinois                       
 *cr                         All Rights Reserved                        
 *cr                                                                   
 ***************************************************************************/

/***************************************************************************
 * RCS INFORMATION:
 *
 *	$RCSfile: R3dDisplayDevice.h,v $
 *	$Author: billh $	$Locker:  $		$State: Exp $
 *	$Revision: 1.4 $	$Date: 1995/05/11 23:42:23 $
 *
 ***************************************************************************
 * DESCRIPTION:
 * 
 * The R3dDisplayDevice implements routines needed to render to a file 
 * in raster3d format
 *
 ***************************************************************************/
#ifndef R3DDISPLAYDEVICE
#define R3DDISPLAYDEVICE

#include <stdio.h>
#include "FileRenderer.h"


class R3dDisplayDevice : public FileRenderer {

private:

  // output file pointer
  FILE *r3d_file;
  
  // output file name
  char *r3d_filename;
  
  // was the file created?
  int Initialized;

protected:

  //
  // assorted graphics functions
  //
  
  void point(float *);
  void sphere(float *);
  void line(float *, float *);
  void cylinder(float *, float *, float);
  void cone(float *, float *, float); 
  void triangle(float *, float *, float *, float *, float *, float *);
  void square(float *, float *, float *, float *, float *);
   
public: 
  // constructor/destructor

  R3dDisplayDevice(char *);
  virtual ~R3dDisplayDevice(void);
  
  virtual void prepare3D(int = TRUE);
  virtual void update(int = TRUE);
  
}; 

#endif

