/***************************************************************************
 *cr                                                                       
 *cr            (C) Copyright 1995 The Board of Trustees of the           
 *cr                        University of Illinois                       
 *cr                         All Rights Reserved                        
 *cr                                                                   
 ***************************************************************************/

/***************************************************************************
 * RCS INFORMATION:
 *
 *      $RCSfile: RayShadeDisplayDevice.h,v $
 *      $Author: khamer $        $Locker:  $                $State: Exp $
 *      $Revision: 1.2 $      $Date: 1995/05/30 21:45:10 $
 *
 ***************************************************************************
 * DESCRIPTION:
 *
 * FileRenderer type for the RayShade raytracer
 *
 ***************************************************************************/
#ifndef RAYSHADEDISPLAYDEVICE
#define RAYSHADEDISPLAYDEVICE

#include <stdio.h>
#include "FileRenderer.h"


class RayShadeDisplayDevice : public FileRenderer {

private:

  // output file pointer
  FILE *ray_file;
  
  // output file name
  char *ray_filename;
  
  // was the file created?
  int Initialized;

protected:

  // fix the scaling in a hackish manner
  
  float scale_fix(float);

  //
  // assorted graphics functions
  //
  
  void point(float *);
  void sphere(float *);
  void line(float *, float *);
  void cylinder(float *, float *, float);
  void cone(float *, float *, float); 
  void triangle(float *, float *, float *, float *, float *, float *);
  void square(float *, float *, float *, float *, float *);
   
public: 
  // constructor/destructor

  RayShadeDisplayDevice(char *);
  virtual ~RayShadeDisplayDevice(void);
  
  virtual void prepare3D(int = TRUE);
  virtual void update(int = TRUE);
  
}; 

#endif

