/***************************************************************************
 *cr                                                                       
 *cr            (C) Copyright 1995 The Board of Trustees of the           
 *cr                        University of Illinois                       
 *cr                         All Rights Reserved                        
 *cr                                                                   
 ***************************************************************************/

/***************************************************************************
 * RCS INFORMATION:
 *
 *	$RCSfile: ReadEDM.h,v $
 *	$Author: billh $	$Locker:  $		$State: Exp $
 *	$Revision: 1.3 $	$Date: 1995/05/11 23:42:27 $
 *
 ***************************************************************************
 * DESCRIPTION:
 *   for the code to read in an electron density map
 * also, the edm data type
 *
 ***************************************************************************/
#ifndef READEDM_H
#define READEDM_H

#include <stddef.h>
#include "Grid.h"

typedef struct edm_t{
   float minx, miny, minz;   // 0, 0, 0
   float maxx, maxy, maxz;   // a, b, c
   float alpha, beta, gamma;
   Grid<float> *grid;
   edm_t(void) {
      grid = NULL;
   }
   ~edm_t(void) {
      if (grid) {
	 delete grid;
      }
   }
};

edm_t *read_edm(char *filename);

#endif

