/***************************************************************************
 *cr                                                                       
 *cr            (C) Copyright 1995 The Board of Trustees of the           
 *cr                        University of Illinois                       
 *cr                         All Rights Reserved                        
 *cr                                                                   
 ***************************************************************************/

/***************************************************************************
 * RCS INFORMATION:
 *
 *      $RCSfile: UIVR.C,v $
 *      $Author: billh $        $Locker:  $                $State: Exp $
 *      $Revision: 1.10 $      $Date: 1995/05/12 00:00:13 $
 *
 ***************************************************************************
 * DESCRIPTION:
 * 
 * Manager for the 3D user interface, including the spatial trackers and any
 * 3D menus, pointers, etc.
 *
 ***************************************************************************/

#include "CommandQueue.h"
#include "CmdDisplay.h"
#include "UIVR.h"
#include "Global.h"
#include "Inform.h"
#include "TrackerList.h"
#include "Buttons.h"
#include "ToolControl.h"
#include "PointerTool.h"
#include "VButton.h"

// externally-accessible items
TrackerList *trackerList;
ToolControl *toolctrl;

static int numCmds = 2;
static int cmdList[2] = { Command::TRACKER_START, Command::TRACKER_PAUSE };

#define MAX_TOOLS 10

// constructor
UIVR::UIVR(UIList *uil, CommandQueue *cq)
 : UIObject("VR Interface", uil, cq), tools(MAX_TOOLS) {
 
 MSGDEBUG(1, "Creating UIVR ..." << sendmsg);
 for (int i=0; i<numCmds; i++)
   command_wanted(cmdList[i]);
 
   // start the TrackerList
 trackerList = new TrackerList();

   // init the button devices
 kbdButtons1 = new Buttons(display, Buttons::KEY_BANK_0);
 kbdButtons2 = new Buttons(display, Buttons::KEY_BANK_1);
 kbdButtons3 = new Buttons(display, Buttons::KEY_BANK_2);
 pointerButtons = new Buttons(display, Buttons::POINTER_BANK_0);

 float q[12] = { 
     0.6, -.7, .6, 
     0.6, -.4, .6, 
     0.9, -.4, .6, 
     0.6, -.4, .8
   };
 vregions = new VRegionList(q, q+3, q+6, q+9, "Main VRegion", scene, 1, TRUE);
// VButtonRotate *tmprot;
// vregions -> append(tmprot = new VButtonRotate(q, q+3, q+6, q+9, 
//                     "Rotate x", scene, 2,
//                     BUTTON0, VButton::ACTIVE, 10, 'x'));
// float delta[3] = {-.4, 0, 0};
// tmprot -> moveby(delta);
// tmprot -> moveby(delta);
// vregions -> append(tmprot = new VButtonRotate(q, q+3, q+6, q+9, 
//                     "Rotate y", scene, 2,
//                     BUTTON0, VButton::ACTIVE, 10, 'y'));
// tmprot -> moveby(delta);
// vregions -> append(tmprot = new VButtonRotate(q, q+3, q+6, q+9, 
//                     "Rotate z", scene, 2,
//                     BUTTON0, VButton::ACTIVE, 10, 'z'));
 //vregions = new VRegion(q, q+3, q+6, q+9, "Andrew", scene, 3);
 Tool *usetool = new PointerTool("Pointer 1", scene);
 tools.append( new ToolControl(0, usetool)); // start for Tool 0
 usetool = new PointerTool("Pointer Tool 2", scene);
 tools.append( new ToolControl(1, usetool));
}

// check for an event; return TRUE if there was one
int UIVR::check_event(void)
{
  // get the most current info from the tracker
  if (trackerList) trackerList -> check_event();
  
    // get the current button state for the different possible inputs
    //  THE FOLLOWING IS TEMPORARY
  if (kbdButtons1) kbdButtons1 -> check_event();
  if (kbdButtons2) kbdButtons2 -> check_event();
  if (kbdButtons3) kbdButtons3 -> check_event();
  if (pointerButtons) pointerButtons -> check_event();
    
  // now that the inputs are in, call the tools so they can do their stuff
  {int n = tools.num();
   for (int i=0; i<n; i++) {
     tools[i] -> check_event();
   }
  }
  return FALSE;
}

int UIVR::act_on_command(int cmdtype, Command *cmd, int suc) {
  
  MSGDEBUG(3, "UIVR: acting on command "<< cmdtype << sendmsg);
  if (suc || cmd)
    ;
    /// THE FOLLOWING IS TEMPORARY
  if (cmdtype == Command::TRACKER_START) {  //  assign the tool to the tracker
    if (trackerList -> tracker(0))
      tools[0] -> tracker(trackerList -> tracker(0), 0);
    if (trackerList -> tracker(0) && tools.num()>=2 && 
              trackerList -> tracker(0) -> numSensors() > 1)
      tools[1] -> tracker(trackerList -> tracker(0), 1);
  }
  // do this until we get button presses on the sensors
  return FALSE;
}


