/***************************************************************************
 *cr                                                                       
 *cr            (C) Copyright 1995 The Board of Trustees of the           
 *cr                        University of Illinois                       
 *cr                         All Rights Reserved                        
 *cr                                                                   
 ***************************************************************************/

/***************************************************************************
 * RCS INFORMATION:
 *
 *	$RCSfile: UNCTracker.h,v $
 *	$Author: leech $	$Locker:  $		$State: Exp $
 *	$Revision: 1.4 $	$Date: 1995/05/16 21:28:47 $
 *
 ***************************************************************************
 * DESCRIPTION:
 *
 * A UNCTracker is a device for measuring the 3D spacial position of an input
 * device; it is a subclass of the Tracker class.
 *
 ***************************************************************************/
#ifndef UNCTRACKER_H
#define UNCTRACKER_H

// project include files
#include "Tracker.h"

// UNC include files
#include "tracker.h"

#define POL_MAXSENSORS	4


class UNCTracker : public Tracker {

private:
  
  // name of tracker
  t_name_type polName;

  // index for use with the UNC library
  t_index polIndex;

  // data structure for holding the data returned from the UNC library 
  t_report_type uncReport[POL_MAXSENSORS];

  // last return value from t_read
  int readRetval;

protected:
  // virtual routine which reads data from sensors, if available
  // returns TRUE if data read and variables changed, FALSE otherwise;
  virtual int my_get_data(int, float *, float *, float *, float *, int);

public:
  // constructors and destructors
  UNCTracker(char *name, int num_sensors = POL_MAXSENSORS);
  virtual ~UNCTracker(void);

};

#endif

