# include "stdio.h"
# define U(x) ((unsigned char)(x))
# define NLSTATE yyprevious=YYNEWLINE
# define BEGIN yybgin = yysvec + 1 +
# define INITIAL 0
# define YYLERR yysvec
# define YYSTATE (yyestate-yysvec-1)
# define YYOPTIM 1
# define YYLMAX 200
# define output(c) (void)putc(c,yyout)
#if defined(__cplusplus) || defined(__STDC__)

#ifdef __cplusplus
extern "C" {
#endif
	int yylex(void);
	int yyback(int *, int);
	int yyinput(void);
	int yylook(void);
	void yyoutput(int);
	int yyracc(int);
	int yyreject(void);
	void yyunput(int);
#ifndef yyless
	void yyless(int);
#endif
#ifndef yywrap
	int yywrap(void);
#endif
#ifdef __cplusplus
}
#endif

#endif

# define input() (((yytchar=yysptr>yysbuf?U(*--yysptr):getc(yyin))==10?(yylineno++,yytchar):yytchar)==EOF?0:yytchar)
# define unput(c) {yytchar= (c);if(yytchar=='\n')yylineno--;*yysptr++=yytchar;}
# define yymore() (yymorfg=1)
# define ECHO (void)fprintf(yyout, "%s",yytext)
# define REJECT { nstr = yyreject(); goto yyfussy;}
int yyleng; extern char yytext[];
int yymorfg;
extern char *yysptr, yysbuf[];
int yytchar;
FILE *yyin = {stdin}, *yyout = {stdout};
extern int yylineno;
struct yysvf { 
	struct yywork *yystoff;
	struct yysvf *yyother;
	int *yystops;};
struct yysvf *yyestate;
extern struct yysvf yysvec[], *yybgin;



# line 6 "AtomLexer.l"
/***************************************************************************
 *cr                                                                       
 *cr            (C) Copyright 1995 The Board of Trustees of the           
 *cr                        University of Illinois                       
 *cr                         All Rights Reserved                        
 *cr                                                                   
 ***************************************************************************/


# line 14 "AtomLexer.l"
/***************************************************************************
 * RCS INFORMATION:
 *
 *	$RCSfile: AtomLexer.l,v $
 *	$Author: dalke $	$Locker:  $		$State: Exp $
 *	$Revision: 1.4 $	$Date: 1995/05/23 20:38:46 $
 *
 ***************************************************************************
 * DESCRIPTION:
 *
 * break atom selection information into its tokens
 *
 ***************************************************************************/



#include <stdlib.h>
#include <strings.h>
#include "AtomParser.h"
#include "y.tab.h"
#include "Inform.h"


# line 36 "AtomLexer.l"
/* redefine the input to come from a string */
#undef input
#undef unput
#define input() (*atomparser_yystring++)
#define unput(c) (*--atomparser_yystring = c)

 /* like_1A  catches raw words like 1A, 3', 5*A
		(start with a number and contain an alpha or ', ", or *)
    like_C5' catches ones like C5' O*, O5*
		(starts with an alpha and has a ', ", or *)
  */
 /*  Problem is that * is too easy to confuse, eg, "x* x"
   I won't worry about this until the next rewrite and only allow
   primes
wierd		[\'\"\*]
  */

		
# define YYNEWLINE 10
yylex(){
int nstr; extern int yyprevious;
while((nstr = yylook()) >= 0)
yyfussy: switch(nstr){
case 0:
if(yywrap()) return(0); break;
case 1:

# line 66 "AtomLexer.l"
	{ return('(');}
break;
case 2:

# line 67 "AtomLexer.l"
	{ return(')');}
break;
case 3:

# line 68 "AtomLexer.l"
{ return(AND);}
break;
case 4:

# line 69 "AtomLexer.l"
{ return(OR);}
break;
case 5:

# line 70 "AtomLexer.l"
	{ return(NOT);}
break;
case 6:

# line 71 "AtomLexer.l"
	{ return(WITHIN);}
break;
case 7:

# line 72 "AtomLexer.l"
             { return(OF);}
break;
case 8:

# line 73 "AtomLexer.l"
	{ return(SAME);}
break;
case 9:

# line 74 "AtomLexer.l"
	{ return(AS);}
break;
case 10:

# line 75 "AtomLexer.l"
{ return(THROUGH);}
break;
case 11:

# line 76 "AtomLexer.l"
          { return(WHERE);}
break;
case 12:

# line 78 "AtomLexer.l"
	{ return(RANGE);}
break;
case 13:

# line 79 "AtomLexer.l"
	{
		  yylval.dval = atof((char *) yytext);
		  return(FLOAT);
		}
break;
case 14:

# line 83 "AtomLexer.l"
{ /* escapes \ and " in a "string"  */
		  yylval.node = new atomparser_node(WORD);
		  yylval.node->sele.s = ((char *) yytext)+1;
		  /* GNU needs a "chop" */
		  yylval.node->sele.s(
			(int) (yylval.node->sele.s).length()-1, 1
					) = "";
		  /* replace \\ with \ */
		  yylval.node->sele.s.gsub("\\\"", "\"");
		  /* replace \" with " */
		  yylval.node->sele.s.gsub("\\\\", "\\");
		  yylval.node->sele.st = DQ_STRING;
		  return WORD;
		}
break;
case 15:

# line 97 "AtomLexer.l"
{ /* escapes \ and ' in a 'string', */
		  /* for instance, this lets you do 'C5\''  */
		  yylval.node = new atomparser_node(WORD);
		  yylval.node->sele.s = ((char *) yytext)+1;
		  /* GNU needs a "chop" */
		  yylval.node->sele.s(
			(int) (yylval.node->sele.s).length()-1, 1
					) = "";
		  /* replace \' with ' */
		  yylval.node->sele.s.gsub("\\'", "'");
		  /* replace \\ with \ */
		  yylval.node->sele.s.gsub("\\\\", "\\");
		  yylval.node->sele.st = SQ_STRING;
		  return WORD;
		}
break;
case 16:

# line 112 "AtomLexer.l"
{
		  msgErr << "Unterminated double quoted string: "
			   << (char *) yytext << sendmsg;
		  return ERROR;
		}
break;
case 17:

# line 117 "AtomLexer.l"
{
		  msgErr << "Unterminated single quoted string: "
			   << (char *) yytext << sendmsg;
		  return ERROR;
		}
break;
case 18:

# line 123 "AtomLexer.l"
	{ return(NLT); /* these are for numeric comparisons */}
break;
case 19:

# line 124 "AtomLexer.l"
	{ return(NLE);}
break;
case 20:

# line 125 "AtomLexer.l"
	{ return(NEQ);}
break;
case 21:

# line 126 "AtomLexer.l"
	{ return(NEQ); /* many people use it */}
break;
case 22:

# line 127 "AtomLexer.l"
	{ return(NGE);}
break;
case 23:

# line 128 "AtomLexer.l"
	{ return(NGT);}
break;
case 24:

# line 129 "AtomLexer.l"
	{ return(NNE);}
break;
case 25:

# line 131 "AtomLexer.l"
	{ return(SLT); /* these are for string comparisons */}
break;
case 26:

# line 132 "AtomLexer.l"
	{ return(SLE);}
break;
case 27:

# line 133 "AtomLexer.l"
	{ return(SEQ);}
break;
case 28:

# line 134 "AtomLexer.l"
	{ return(SGE);}
break;
case 29:

# line 135 "AtomLexer.l"
	{ return(SGT);}
break;
case 30:

# line 136 "AtomLexer.l"
	{ return(SNE);}
break;
case 31:

# line 137 "AtomLexer.l"
	{ return(MATCH);}
break;
case 32:

# line 139 "AtomLexer.l"
	{ return(ADD);}
break;
case 33:

# line 140 "AtomLexer.l"
	{ return(SUB);}
break;
case 34:

# line 141 "AtomLexer.l"
	{ return(DIV);}
break;
case 35:

# line 142 "AtomLexer.l"
	{ return(MULT);}
break;
case 36:

# line 143 "AtomLexer.l"
	{ return(MOD);}
break;
case 37:

# line 144 "AtomLexer.l"
	{ return(EXP);}
break;
case 38:

# line 145 "AtomLexer.l"
	{ return(EXP);}
break;
case 39:

# line 147 "AtomLexer.l"
	;
break;
case 40:

# line 149 "AtomLexer.l"
{ /* catch raw names like: */
		  /* 5' 1A C4' 3'A           */
		  yylval.node = new atomparser_node(WORD);
		  yylval.node->sele.s = (char *) yytext;
		  yylval.node->sele.st = RAW_STRING;
		  return WORD;
		}
break;
case 41:

# line 156 "AtomLexer.l"
{ yylval.ival = atoi((char *) yytext); 
		  return(INT); 
		}
break;
case 42:

# line 159 "AtomLexer.l"
{  /* standard variable names */
		  yylval.node = new atomparser_node(WORD);
		  yylval.node->sele.s = (char *) yytext;
		  yylval.node->sele.st = RAW_STRING;
		  int len = strlen((char *) yytext);
		  int i;
		  if ((i= atomparser_yylookup((char *) yytext, len)) >= 0) {
		     yylval.node->extra_type = i;
		     if (atomparser_symbols[i]->is_a ==
			 SymbolTableName::FUNCTION) {
			yylval.node->node_type = FUNC;
			return FUNC;
		     } else if (atomparser_symbols[i]->is_a ==
				SymbolTableName::KEYWORD) {
			yylval.node->node_type = KEY;
			return KEY;
		     } else if (atomparser_symbols[i]->is_a ==
				SymbolTableName::SINGLEWORD) {
			yylval.node->node_type = SINGLE;
			return SINGLE;
		     } else if (atomparser_symbols[i]->is_a ==
				SymbolTableName::STRINGFCTN) {
			yylval.node->node_type = STRFCTN;
			return STRFCTN;
		     }
		  }
		  return WORD;
                }
break;
case 43:

# line 187 "AtomLexer.l"
	{ msgErr << "Bad character:"
			 << int(*yytext) << ':'
			 << *yytext << sendmsg; 
		  return ERROR; 
		}
break;
case -1:
break;
default:
(void)fprintf(yyout,"bad switch yylook %d",nstr);
} return(0); }
/* end of yylex */

#include "SymbolTable.h"

int atomparser_yylookup(const char *s, int len) 
{
   int i;
   for(i=0; i<atomparser_numsymbols; i++) {
      if (atomparser_symbols[i]->regex->match(s,len) != -1) {
//	 printf("Found match for symbol %s.\n", s);
	 return i;
      }
   }
//   printf("Didn't find a match for %s\n", s);
   return -1;
}
      

// pointer to the input string
char *atomparser_yystring;

// pointer to the array of symbols
SymbolTableName **atomparser_symbols;
int atomparser_numsymbols;



