#######################################  Laura Joana SILVA LOPES, Mar 2017 #######################################
#
# Script to make the AMS analysis. Output file is analysis and contains the mean for T3, the iteration number and
# pAMS.
# Usage: make_analysis_smart.sh stepsize prefix amsdir outdir getpaths
#
##################################################################################################################
#! /bin/bash
source $toall_smart
logfile=$outdir"/finalrun.ams.log"
# USER settings
numhist=50

outfile=$outdir/analysis

# DO NOT CHANGE AFTER THIS LINE 
commandline="tclsh $smart_iteration -amsdir $outdir -outdir $outdir"
eval $commandline

# reconstruction.tcl
commandline="tclsh $smart_reconstruction -amsdir $outdir -outdir $outdir -stepsize $amssteptime -shareddata $prefix"
eval $commandline

# histogram.tcl
sed '/^$/d' $outdir/reconstruction.dat | awk '{print $1}' | grep -B 1 "#" | grep -v "#" | grep -v "\-\-" > $outdir/forhistogram
sed '/^$/d' $outdir/reconstruction.dat | awk '{print $1}' | tail -1 >> $outdir/forhistogram
commandline="tclsh $smart_histogram -outdir $outdir -forfile $outdir/forhistogram -num $numhist"
eval $commandline
rm $outdir/forhistogram

# write outfile
if [ -a "$outfile" ];
then
	rm $outfile
fi

# extract paths
pathnum=`grep "shutting down" $logfile | grep "reached" | awk '{print $4}'`
if [ $getpaths == "on" ] && [ $pathnum -gt 0 ];
then
	echo "pathfile $outdir/pathlist" >> $outfile
	commandline="$smart_get_paths $prefix $outdir"
	eval $commandline
fi
if [ $amstype == "var" ];
then
	echo -ne "T1\t" >> $outfile
	$smart_media $outdir/$prefix.t1 | awk '{print $1}' >> $outfile
	echo -ne "T2\t" >> $outfile
	$smart_media $outdir/$prefix.t2 | awk '{print $1}' >> $outfile
fi
if [ `grep -c "insuffisant" $logfile` -gt 0 ];
then
	proba=0
	t3=""
else
	t3=`grep "Mean" ${outdir}/histogram.dat | awk '{print $3}'`
	proba=`$smart_proba ${outdir}/${prefix}.killed`
fi
echo -ne "T3\t$t3\n" >> $outfile
echo -ne "iter\t" >> $outfile
val1=`head -2 $outdir"/iterationTime.dat" | tail -1 | awk '{print $1}'`
val2=`tail -1 $outdir"/iterationTime.dat" | awk '{print $1}'`
let "m = val2 - val1 + 1"
echo $m >> $outfile
echo -ne "pAMS\t$proba\n" >> $outfile
echo -ne "walltime\t" >> $outfile
grep 'shutting down AMS at' $outdir/finalrun.ams.log | awk '{print $8}' | sed 's/,//g' >> $outfile
echo -ne "cputime\t" >> $outfile
tail -5 $outdir/amsrun.log | grep "CPUTime" | awk '{print $4}' >> $outfile
