#######################################  Laura Joana SILVA LOPES, Mar 2017 #######################################
#
# Script to run one AMS instance
# Usage: for_smart.sh procnum
# variable namd should contain the path to the namd executable. Include an export to bashrc to just do it once !
# variable functions_smart should contain the path to the functions_smart.sh script
#
##################################################################################################################
#! /bin/bash
source $toall_smart
truntime=`date +%s`
procnum=$1
export outdir=$parent"/inst."$(printf "%04d" $procnum)
# (1) create the directories and put frames in it and create conf files ##########################################
echo "starting (1)";date
confAMSFile=$outdir"/ams.conf"
AMSlogFile=$outdir"/finalrun.ams.log"
echo "looking for $AMSlogFile"
if [ ! -e "$AMSlogFile" ]; # this is not a repair situation
then
	# start creating conf files: global parts
	# conf file to run the initialization procedure
	confInitFile=$outdir"/init.conf"
	startwriting $confInitFile
	if [ $amstype == "single" ];
	then
		initcommon=$smart_path"/baseconf_single.init"
		writeinit "bincoordinates $icprefix.coor"
	        writeinit "binvelocities $icprefix.vel"
	        writeinit "extendedsystem $icprefix.xsc"
		writeinit "`cat $initfile`" # basic namd variables
	        writeinit "set name $outdir/init"
	        writeinit "set AMS_sharedDataPrefix $outdir/$prefix"
	        writeinit "set numRep $numrep"
	        writeinit "set maxz $zmax"
		writeinit "set amsstep $amssteptime"
		writeinit "source $zone"
	        writeinit "source $variables"
	        writeinit "source $measure"
	        writeinit "`cat $initcommon`" # global part
	fi
	if [ $amstype == "mult" ];
	then
		initcommon=$smart_path"/baseconf_mult.init"
		writeinit "`cat $initfile`" # basic namd variables
		writeinit "temperature \$temperature"
	        writeinit "set icprefix $icprefix"
	        writeinit "set name $outdir/init"
	        writeinit "set AMS_sharedDataPrefix $outdir/$prefix"
	        writeinit "set numRep $numrep"
	        writeinit "set maxz $zmax"
		writeinit "set amsstep $amssteptime"
		writeinit "source $zone"
		writeinit "source $variables"
		writeinit "source $measure"
	        writeinit "`cat $initcommon`" # global part
	fi
	if [ $amstype == "var" ];
	then
	        initcommon=$smart_path"/baseconf_var.init"
	        writeinit "bincoordinates $icprefix.coor"
	        writeinit "binvelocities $icprefix.vel"
	        writeinit "extendedsystem $icprefix.xsc"
	        writeinit "`cat $initfile`" # basic namd variables
	        writeinit "set freq $amssteptime"
	        writeinit "set name $outdir/init"
	        writeinit "set AMS_sharedDataPrefix $outdir/$prefix"
	        writeinit "set numRep $numrep"
	        writeinit "set maxz $zmax"
	        writeinit "set zmin $zmin"
	        writeinit "set amsstep $amssteptime"
	        writeinit "source $zone"
	        writeinit "source $variables"
	        writeinit "source $measure"
	        writeinit "`cat $initcommon`" # global part
	fi
	# conf file to run ams
	amscommon=$smart_path"/baseconf.ams"
	startwriting $confAMSFile
	#writeams "coordinates $pdbfile"
	writeams "`cat $initfile`" # basic namd variables
	writeams "temperature \$temperature"
	writeams "set AMS_stepSize $amssteptime"
	writeams "############ sources ############"
	writeams "source $zone"
	writeams "source $measure"
	writeams "source $variables"
	writeams "source $amsscript"
	writeams "set AMS_sharedDataPrefix $outdir/$prefix"
	writeams "outputname $outdir/finalrun"
	writeams "set AMS_thresholdMaxZ $zmax"
	writeams "set AMS_wallTimeLimit [expr {60 * 120 * $timelimit}]"
	writeams "set AMS_toKill $tokill"
	writeams "`cat $amscommon`" # fixed ams commands
	
# (2) initiate ams replicas and prepare for AMS run ##############################################################
	echo "starting (2)";date
	logInitFile=$outdir"/init.log"
	command="$namdcommand $confInitFile &> $logInitFile &"
	eval $command
	wait
	if [ `grep -c "FATAL ERROR" $logInitFile` -gt 0 ];
	then
		echo "got error in init run for instance $procnum!"
		grep "FATAL ERROR" $logInitFile | head -1
		kill $$
	elif [ `grep -c "End of program" $logInitFile` -eq 0 ];
	then
		echo "due to some error the initialization process failled"
		echo "for details see file $logInitFile"
		kill $$
	fi
	echo "ended initialization process"
	echo "preparing to AMS run"
	command="$genSharedData -prefix $prefix -datadir $outdir -zMax $zmax"
	eval $command # generating iter, sys, status, proba and rcf files
	now=`date +%s`
	let "runtime2=now-truntime"
else
	runtime2=0
	echo "this is a repair"
fi	
# (3) run AMS ####################################################################################################
echo "starting (3)";date
logAMSFile=$outdir"/amsrun.log"
command="$namdcommand $confAMSFile &> $logAMSFile &"
eval $command
wait
if [ `grep -c "FATAL ERROR" $logAMSFile` -gt 0 ];
then
	echo "got error in AMS run for instance $procnum!"
	grep "FATAL ERROR" $logAMSFile | head -1
	kill $$
elif [ `grep -c "shutting down" $AMSlogFile` -eq  0 ];
then
	echo "namd process killed in AMS run for instance $procnum!"
	kill $$
elif [ `grep -c "End of program" $logAMSFile` -eq  0 ];
then
	echo echo "due to some error the AMS step failled"
	echo "for details see file $logAMSFile"
	kill $$
fi
echo "AMS done!"
now=`date +%s`
let "runtime3=now-truntime-runtime2"

# (4) analyse the results ########################################################################################
echo "starting (4)";date
time3=$outdir"/time3.dat"
eval $smart_analysis
sed '/^$/d' $outdir/reconstruction.dat | awk '{print $1}' | grep -B 1 "#" | grep -v "#" | grep -v "\-\-" >> $time3
sed '/^$/d' $outdir/reconstruction.dat | awk '{print $1}' | tail -1 >> $time3
now=`date +%s`
let "runtime4=now-truntime-runtime2-runtime3"
let "truntime=now-truntime"

# Giving runtimes
echo "End of instance $procnum"
hrformat=`$smart_tempo $truntime`
echo "total runtime: $truntime s ($hrformat)"
hrformat=`$smart_tempo $runtime2`
echo -ne "\ttime to initiate the replicas: $runtime2 s ($hrformat)\n"
hrformat=`$smart_tempo $runtime3`
echo -ne "\ttime to run AMS: $runtime3 s ($hrformat)\n"
hrformat=`$smart_tempo $runtime4`
echo -ne "\ttime to make the analysis of the results: $runtime4 s ($hrformat)\n"
# removing files if the user wants to
if [ $removefiles == "yes" ];
then
        rm -rf $outdir/*frames
        rm -f $outdir/*dcd
        rm -f $outdir/finalrun.colvars.*
        rm -f $outdir/init.*
		rm -rf $outdir/*traj
		rm -rf $outdir/*zdat
#	rm -f $outdir/amsrun.log
fi
echo "######### analysis file #########"
cat $outdir"/analysis"
# marking the end of all
echo "acabou"
