#!/usr/bin/env tclsh

# Script to perform the reconstruction of the reactive trajectories using ZDAT data
# Christopher G. Mayne
# 07/12/2015

# modified by Laura SILVA LOPES ###################################
# need to pass:
# amsdir = directory with AMS results
# stepsize = AMS_stepSize
# shareddata = AMS_sharedDataPrefix
# outdir = output directory
# Usage: reconstruction.tcl -amsdir <ams run dir> -stepsize <ams step size> -shareddata <prefix> -outdir <outdir>

# parse flags
foreach {flag val} $argv { set [string range $flag 1 end] $val }

# USER SETTINGS
set AMS_sharedDataPrefix [file join $amsdir $shareddata]
set AMS_stepSize $stepsize
set zdatDir $amsdir
set ts 1 ; # fs/step
set outputfilename [file join $outdir "reconstruction.dat"]
############################################################### end

# SCRIPT (do not modify below here)
set infile  [open ${AMS_sharedDataPrefix}.sys r]
set outfile [open $outputfilename w]
# read through the system data file
while { ![eof $infile] } {
	
	# handle the data one system at a time
	set inline [string trim [gets $infile]]
	if { $inline eq "" } { continue }
	# system data
	lassign $inline sysID finalZ history
	set trajData {}
	
	# cycle through each zdat file
	foreach ele $history {

		lassign $ele filePrefix lastFrame
		#puts $outfile "zdat file: $file"
		# read through the zdat file, computing the traj time with each step
		set zdatFileIn [open [file join $zdatDir ${filePrefix}.zdat] r]
		while { ![eof $zdatFileIn] } {

			set zdatinline [string trim [gets $zdatFileIn]]
			set nframe [lindex $zdatinline 0]
			if { $zdatinline eq "" || $nframe > $lastFrame } {
				continue
			} else {
				lappend trajData $zdatinline
				#puts $outfile $zdatinline
			}
		}
		# clean up
		close $zdatFileIn
	}
	# process the trajdata
	set trajTime 0
	set prevframe 0
	puts $outfile "\n# Reconstruction for system replica $sysID"; flush $outfile

	foreach ele $trajData {
		lassign $ele f z
		if { $f == 0 } {
			puts $outfile "$trajTime\t$z"
			set prevframe 0
		} else {
			# dT = #frames_between_reported_rc * (1 AMS_step / frame) * (500 ts / AMS_step) * (1 fs/ts) * (1 ps / 1,000 fs) = time increment in ps
			# set dT [expr {1.0 * ($f - $prevframe) * $AMS_stepSize * $ts * (1.0/1000)}]
			# Laura: time in fs because had problems
			set dT [expr {1.0 * ($f - $prevframe) * $AMS_stepSize * $ts}]
			set trajTime [expr {$trajTime + $dT}]
			puts $outfile "$trajTime\t$z"
			set prevframe $f
		}
	}

	# done with that system
	puts $outfile "";

}

# clean up
close $infile
close $outfile
