#######################################  Laura Joana SILVA LOPES, Jun 2017 #######################################
#
# auxiliary functions that other scripts will use
# this file is sourced by all the scripts
# export its path as toall_smart (put it in bashrc to just do it once)
#
##################################################################################################################
#! /bin/bash
####################################### USER VARIABLES ##########################################
# please give the path to the executables
smart_path=
amsscript=
namd=
#################################################################################################
# Do not change after this line
smart_help=$smart_path"/HELP"
smart_runams=$smart_path"/for_smart.sh"
smart_analysis=$smart_path"/make_analysis_smart.sh"
smart_iteration=$smart_path"/iterationTime.tcl"
smart_reconstruction=$smart_path"/reconstruction.tcl"
smart_histogram=$smart_path"/histogram.tcl"
smart_get_paths=$smart_path"/get_paths.sh"
smart_proba=$smart_path"/ams_proba"
smart_media=$smart_path"/media"
genSharedData=$smart_path"/ams_genSharedData.novo.tcl"
smart_tempo=$smart_path"/tempo"
#################################################################################################
function startwriting () {
        local file=$1
        local type
        local arqname
        arqname=`echo $file | rev | cut -d"/" -f1 | rev | cut -d"." -f1`
        if [[ $arqname == "init" ]];
        then
                type="initialization"
        fi
        if [[ $arqname == "ams" ]];
        then
                type="AMS"
        fi
        echo "# Configuration file to run $type procedure" >> $file
        echo -ne "# created by for_smart.sh script at " >> $file
        date >> $file
}
function writeinit () {
        echo "$@" >> $confInitFile
}
function writeams () {
        echo "$@" >> $confAMSFile
}
function changeset () {
        local file=$1 what=$2
        local write=$(echo $3 | sed 's/\//\\\//g')
        local line=`grep -n "set $what" $file | head -1 | cut -d":" -f1`
        sed -i $line's/.*/set '$what' "'$write'"/' $file
}
function changepar () {
	local file=$1 what=$2
	local write=$(echo $3 | sed 's/\//\\\//g')
	local line=`grep -n "$what" $file | head -1 | cut -d":" -f1`
	sed -i $line's/.*/'$what' "'$write'"/' $file
}
