#!/bin/bash

gnuplot << EOF

set size 1.2, 1.2
set terminal postscript eps solid color enhanced lw 3.0 "Times-Roman" 28

set encoding iso_8859_1

set xrange [0:20]
set yrange [0:20]

set format x "%g^{\260}"
set format y "%g^{\260}"
set xtics 4
set ytics 4

set nokey

set output "fig1.ps"
set xlabel "{/Symbol q_{1}}"
set ylabel "{/Symbol q_{7}}"
plot \
"cv-R.txt" u (2*180*acos(\$2)/acos(-1)):(2*180*acos(\$26)/acos(-1)):(int(\$0/21)) w l palette

set output "fig2.ps"
set xlabel "{/Symbol q_{2}}"
set ylabel "{/Symbol q_{8}}"
plot \
"cv-R.txt" u (2*180*acos(\$6)/acos(-1)):(2*180*acos(\$30)/acos(-1)):(int(\$0/21)) w l palette

set output "fig3.ps"
set xlabel "{/Symbol q_{3}}"
set ylabel "{/Symbol q_{9}}"
plot \
"cv-R.txt" u (2*180*acos(\$10)/acos(-1)):(2*180*acos(\$34)/acos(-1)):(int(\$0/21)) w l palette

set output "fig4.ps"
set xlabel "{/Symbol q_{4}}"
set ylabel "{/Symbol q_{10}}"
plot \
"cv-R.txt" u (2*180*acos(\$14)/acos(-1)):(2*180*acos(\$38)/acos(-1)):(int(\$0/21)) w l palette

set output "fig5.ps"
set xlabel "{/Symbol q_{5}}"
set ylabel "{/Symbol q_{11}}"
plot \
"cv-R.txt" u (2*180*acos(\$18)/acos(-1)):(2*180*acos(\$42)/acos(-1)):(int(\$0/21)) w l palette

set output "fig6.ps"
set xlabel "{/Symbol q_{6}}"
set ylabel "{/Symbol q_{12}}"
plot \
"cv-R.txt" u (2*180*acos(\$22)/acos(-1)):(2*180*acos(\$46)/acos(-1)):(int(\$0/21)) w l palette

set autoscale xy

set xlabel "Iteration" offset 0.5,0 font "Times-Roman,48"
set xtics autofreq
set format x "%g"

set ylabel "Iteration" offset 0.5,0 font "Times-Roman,48"
set ytics autofreq
set format y "%g"

set output "fig7.ps"
plot "pair-R.txt" u 1:2:(\$3*180/pi) w image

set key top right
set ylabel "String RMSD (degrees)" offset 1,0 font "Times-Roman,48"
set output "fig8.ps"
plot "s-rmsd-R.txt" u 1:(\$2*180/pi) w l lt 1 t "wrt first", \
"s-rmsd-R.txt" u 1:(\$4*180/pi) w l lt 3 t "wrt last"

EOF

for i in `seq 8`
do
epstopdf fig$i.ps; rm fig$i.ps
done
