#!/bin/bash

ni=20 #number of images in smwst
nc=5 # number of copies in smwst
job_id=4 # last smwst job_id
# pick the right output directory
output=../../../1-smwst/0-parallel/output
#output=../../../1-smwst/0-parallel/sample-output
force=10000 # force constant

for i in `seq 0 $((ni-1))`
do
    output_root=$output/$i/glpt
    for j in `seq 0 4`
    do
	cp $output_root.job$job_id.$((i*nc+j)).coor ../input/init.$((i*nc+j)).coor
	cp $output_root.job$job_id.$((i*nc+j)).vel ../input/init.$((i*nc+j)).vel
	cp $output_root.job$job_id.$((i*nc+j)).xsc ../input/init.$((i*nc+j)).xsc
    done
done

cat $output/job$job_id.log.0 | \
grep "TCL: Reparametrized " | tail -$ni | awk -v nc=$nc -v force=$force '{
    for(i=1;i<NF/4;i++) {
	q[0,i]=$(4*i+1)
	q[1,i]=$(4*i+2)
	q[2,i]=$(4*i+3)
	q[3,i]=$(4*i+4)
    }
    if ($4>0) {
	for(t=1;t<=nc;t++) {
	    replica=nc*($4-1)+t
	    printf "set centers(%d) [list harm \"forceConstant \{ %s \} centers \{ ",replica,force
	    for(i=1;i<NF/4;i++) {
		Q[0]=q_[0,i]+(q[0,i]-q_[0,i])*t/nc
		Q[1]=q_[1,i]+(q[1,i]-q_[1,i])*t/nc
		Q[2]=q_[2,i]+(q[2,i]-q_[2,i])*t/nc
		Q[3]=q_[3,i]+(q[3,i]-q_[3,i])*t/nc
		r=sqrt(Q[0]*Q[0]+Q[1]*Q[1]+Q[2]*Q[2]+Q[3]*Q[3])
		printf "( %s , %s , %s , %s ) ",Q[0]/r,Q[1]/r,Q[2]/r,Q[3]/r
	    }
	    printf "\} \" ]",$i;printf"\n"
	}
    } else {
	printf "set centers(%d) [list harm \"centers \{ ",0
	for(i=1;i<NF/4;i++) printf "( %s , %s , %s , %s ) ",q[0,i],q[1,i],q[2,i],q[3,i]
	printf "\} \" ]",$i;printf"\n"
    }
    for(i=1;i<NF/4;i++) {
	q_[0,i]=q[0,i]
	q_[1,i]=q[1,i]
	q_[2,i]=q[2,i]
	q_[3,i]=q[3,i]
    }
}' > ../centers.tcl

