#!/bin/bash

gnuplot << EOF

set size 1.2, 1.2
set terminal postscript eps solid color enhanced lw 3.0 "Times-Roman" 42

set encoding iso_8859_1

set key top right
set xrange [0:20]
set output "pmf.ps"
set xlabel "Orientation Angle (degrees)"
set ylabel "PMF (kcal/mol)"
plot "pmf.err" u 1:2 w lp lt 1 t "{/Symbol q_1}", \
"pmf.err" u 1:2:3 w e lt 1 t "", \
"pmf.err" u 1:14 w lp lt 3 t "{/Symbol q_7}", \
"pmf.err" u 1:14:15 w e lt 3 t ""

EOF

ps2epsi pmf.ps
epstopdf pmf.epsi

rm pmf.ps pmf.epsi

