#!/bin/bash

gnuplot << EOF

set size 1.2, 1.2
set terminal postscript eps solid color enhanced lw 3.0 "Times-Roman" 42

set encoding iso_8859_1

set key top left

set output "fe.ps"
set xlabel "Image Id"
set ylabel "Free Energy (kcal/mol)"
plot "< tail -4 density.err | awk '{print \$3,\$4}'" w lp lt -1 t "density.err", \
"< tail -4 bootstrap.err | awk '{print \$3,\$4}'" w lp lt 1 t "bootstrap.err", \
"< tail -4 bootstrap.err | awk '{print \$3,\$4,\$5}'" w e lt 1 t ""

EOF

epstopdf fe.ps; rm fe.ps

