#ifndef ALIGNMENT_H
#define ALIGNMENT_H

#include <math.h>
#include <stdio.h>
#include <string.h>

#define DB 0 // set to 1 to debug
#define MSL 2000 // max seq length allowable, used for temporary buffers
#define PDB_PATH "/home/mjanuszy/Projects/ssAlign/data/RotatedPDB/"

// not yet fully implemented
class Structure{
  public:
    char *pdbFilePath; //directory in which pdbFileName resides
    char* pdbFileName; // name of pdb file found in pdbFilePath
    char pdbChain; // chain in pdb file
    int* pdbNumbering; // pdb residue number for sequence residues
    float **caCoordinates;
    int length;
//    void readFromPdbFile(char *s);
    void readFromPdbFile();
    void setPdbFileName(char *s);
    void setPdbFilePath(char *s);
    Structure(char *s, char *p); // pdbFileName, pdbFilePath
    Structure(char *s); // pdbFileName, assume default path
    Structure();
    ~Structure();
    Structure& operator= (const Structure&);
    Structure(const Structure&);
};


class Sequence{
  public:
    int length;
    int lengthWithoutGaps;
    bool isSecondary;
    bool* isGap;
    bool* isEndGap;
    char* name;
    char* residues;
    char* residuesWithoutGaps;
    int *residuesIndexToResiduesWithoutGapsIndex;
    int *residuesWithoutGapsIndexToResiduesIndex;
    int getLeft(int);
    int getRight(int);
    void setName(char *s);
    void setName(char *s, int n);
    void setResidues(char *s);
    Structure structure;
    Sequence(char *s);
    Sequence();
    ~Sequence();
    Sequence& operator= (const Sequence&);
    Sequence(const Sequence&);
};

class Alignment{
  public:
    void readCaCoordinates();
    void readFromFile(char *s);
    void printFasta();
    void printMsa();
    void printPwa();
    void setIsSecondary();
    Alignment(char *s);
    Alignment();
    ~Alignment();
    Alignment& operator= (const Alignment&);
    Alignment(const Alignment&);
    int nSequences, nProteins, maximumSequenceLength;
    char *name;
    Sequence *sequences;
};

#endif
