
#include "alphabetBuilder.h"


AlphabetBuilder::AlphabetBuilder() {

  return;
}

Alphabet* AlphabetBuilder::getDnaAlphabet() {

  int length = 6;
  Symbol** list = new Symbol* [length];
  list[0] = new Symbol('A',"ADE","Adenine");
  list[1] = new Symbol('C',"CYT","Cytosine");
  list[2] = new Symbol('G',"GUA","Guanine");
  list[3] = new Symbol('T',"THY","Thymine");
  list[4] = new Symbol('-'," - ","Gap");
  list[5] = new Symbol('X',"XXX","Unknown");

  Alphabet* alphabet = new Alphabet(length, list);
  alphabet->setBackbone("P");
  alphabet->setGap(alphabet->getSymbol('-'));
  alphabet->setUnknown(alphabet->getSymbol('X'));
  
  //printf("Yo1\n");
  for (int i=0; i<length; i++) {
    delete list[i];
  }

  //printf("Yo2\n");
  delete list;

  //printf("Yo3\n");
  return alphabet;
}


Alphabet* AlphabetBuilder::getRnaAlphabet() {

  
  int length = 6;
  Symbol** list = new Symbol* [length];
  list[0] = new Symbol('A',"ADE","Adenine");
  list[1] = new Symbol('C',"CYT","Cytosine");
  list[2] = new Symbol('G',"GUA","Guanine");
  list[3] = new Symbol('U',"URA","Uracil");
  list[4] = new Symbol('-'," - ","Gap");
  list[5] = new Symbol('X',"XXX","Unknown");

  Alphabet* alphabet = new Alphabet(length, list);
  alphabet->setBackbone("P");
  alphabet->setGap(alphabet->getSymbol('-'));
  alphabet->setUnknown(alphabet->getSymbol('X'));

  for (int i=0; i<length; i++) {
    delete list[i];
  }
  
  delete list;
  
  return alphabet;
}


Alphabet* AlphabetBuilder::getProteinAlphabet() {

  
  int length = 24;
  Symbol** list = new Symbol* [length];
  
  list[0] = new Symbol('A',"ALA","Alanine");
  list[1] = new Symbol('R',"ARG","Arginine");
  list[2] = new Symbol('N',"ASN","Aspartine");
  list[3] = new Symbol('D',"ASP","Aspartate");
  list[4] = new Symbol('C',"CYS","Cysteine");
  list[5] = new Symbol('Q',"GLN","Glutamine");
  list[6] = new Symbol('E',"GLU","Glutamate");
  list[7] = new Symbol('G',"GLY","Glycine");
  list[8] = new Symbol('H',"HIS","Histidine");
  list[9] = new Symbol('I',"ILE","Isoleucine");
  list[10] = new Symbol('L',"LEU","Leucine");
  list[11] = new Symbol('K',"LYS","Lysine");
  list[12] = new Symbol('M',"MET","Methionine");
  list[13] = new Symbol('F',"PHE","Phenylalanine");
  list[14] = new Symbol('P',"PRO","Proline");
  list[15] = new Symbol('S',"SER","Serine");
  list[16] = new Symbol('T',"THR","Threonine");
  list[17] = new Symbol('W',"TRP","Tryptophan");
  list[18] = new Symbol('Y',"TYR","Tyrosine");
  list[19] = new Symbol('V',"VAL","Valine");
  list[20] = new Symbol('-'," - ","Gap");
  list[21] = new Symbol('B',"D/N","Asp or Asn");
  list[22] = new Symbol('Z',"E/Q","Glu or Gln");
  list[23] = new Symbol('X',"XXX","Unknown");

  Alphabet* alphabet = new Alphabet(length, list);
  alphabet->setBackbone("CA");
  alphabet->setGap(alphabet->getSymbol('-'));
  alphabet->setUnknown(alphabet->getSymbol('X'));

  for (int i=0; i<length; i++) {
    delete list[i];
  }

  delete list;

  return alphabet;
}
