/*****************************************************************************
*
*            (C) Copyright 2005 The Board of Trustees of the
*                        University of Illinois
*                         All Rights Reserved
*
******************************************************************************/

/*****************************************************************************
* RCS INFORMATION:
*
*       $RCSfile: fastaReader.h,v $
*       $Author: erobert3 $        $Locker:  $             $State: Exp $
*       $Revision: 1.1.2.2 $           $Date: 2005/01/03 06:16:43 $
*
******************************************************************************/

// $Id: fastaReader.h,v 1.1.2.2 2005/01/03 06:16:43 erobert3 Exp $

#ifndef FASTAREADER_H
#define FASTAREADER_H

#include "alignedSequence.h"
#include "alphabet.h"
#include "sequence.h"
#include "sequenceAlignment.h"

#include <stdio.h>
#include <string.h>

class FASTAReader {

 public:
  FASTAReader(Alphabet* alpha);
  ~FASTAReader();

  int setFilename(char* fn);
  int setPath(char* p);
  Sequence* getSequence(int seqIndex);
  Sequence* getNextSequence();
  AlignedSequence* getAlignedSequence(int seqIndex);
  AlignedSequence* getNextAlignedSequence();
  SequenceAlignment* getSequenceAlignment();
  int getSequenceCount();
  
 private:
  int getSequenceName(char* tempStr, char* name);
  int checkFullName();

 private:
  Alphabet* alphabet;
  char* filename;
  char* path;      // Path to the file
  char* fullName;  // path + filename
  int currentSequence;

};

#endif
