
#include "sequenceAlignment.h"


// Constructor
SequenceAlignment::SequenceAlignment(int mL, int mSC)
  : length(0), maxLength(mL), sequenceCount(0), maxSequenceCount(mSC) {

  alignment = new AlignedSequence* [maxSequenceCount];

  return;
}


// Destructor
SequenceAlignment::~SequenceAlignment() {

  for (int i=0; i<sequenceCount; i++) {
    delete alignment[i];
  }

  delete alignment;

  return;
}


// addSequence
int SequenceAlignment::addSequence(AlignedSequence* sequence) {
  
  if (sequenceCount < maxSequenceCount &&
      sequence->getLength() <= maxLength) {
    alignment[sequenceCount] = sequence;
    sequenceCount++;
    //printf("sequenceCount: %d, maxSequenceCount: %d\n",sequenceCount,maxSequenceCount);
    if (length < sequence->getLength()) {
      length = sequence->getLength();
    }
    return 1;
  }
  else {
    printf("length: %d, maxLength: %d\n",sequence->getLength(),maxLength);
    printf("%s\n",sequence->toString());
  }

  return 0;
}


// getSequence
AlignedSequence* SequenceAlignment::getSequence(int i) {

  //printf("Yo!\n");
  if (i < sequenceCount) {
    return alignment[i];
  }

  //printf("Yo!!\n");
  return 0;
}


// getSymbol
Symbol* SequenceAlignment::getSymbol(int i, int j) {

  if (i < sequenceCount && j < length) {
    return alignment[i]->getSymbol(i);
  }

  return 0;
}


// getLength
int SequenceAlignment::getLength() {

  return length;
}


// getSequenceCount
int SequenceAlignment::getSequenceCount() {

  return sequenceCount;
}
