/*****************************************************************************
*
*            (C) Copyright 2005 The Board of Trustees of the
*                        University of Illinois
*                         All Rights Reserved
*
******************************************************************************/

/*****************************************************************************
* RCS INFORMATION:
*
*       $RCSfile: sequenceQR.h,v $
*       $Author: erobert3 $        $Locker:  $             $State: Exp $
*       $Revision: 1.1.2.4 $           $Date: 2005/02/10 23:16:20 $
*
******************************************************************************/

// $Id: sequenceQR.h,v 1.1.2.4 2005/02/10 23:16:20 erobert3 Exp $

#ifndef SEQUENCEQR_H
#define SEQUENCEQR_H


// XXX - Eventually make child of superclass QR (along with Sequence QR)
class SequenceQR{
  
 public:
  SequenceQR(SequenceAlignment *alignment, float identityCutoff, int preserveCount, int performGapScaling, float gapScaleParameter);
  ~SequenceQR();
  SequenceAlignment* SequenceQR::qr();
  
 private:
  void householder(int currentColumn);
  void permuteColumns(int currentColumn);
  int isSequenceAboveIdentityCutoff(int currentColumn);
  float frobeniusNormByK(int k, int currentRow);
  float frobeniusNormByJ(int j);
  void scaleGapData();
  
 private:
  /*
    Anytime you access the third index from coordMatrix, go through the
    columnList; So coordMatrix[i][j][k] becomes coordMatrix[i][j][columnList[k]];
    This level of indirection eliminates array copying and saves the sequence
    order.
  */
  SequenceAlignment *alignment;
  float identityCutoff;
  int preserveCount;
  int performGapScaling;
  float gapScaleParameter;
  float ***matrix;
  int *columnList;         // indices for columns which may be permuted
  int cMi;                 // number of residue columns in coordMatrix (alignment column)
  int cMj;                 // number of coordinates for a coordMatrix residue (x,y,z,gap)
  int cMk;                 // number of sequences in coordMatrix
};

#endif
