
#include "structure.h"

#include "stdio.h"


// Constructor
Structure::Structure(int l, Alphabet* a, char* n)
  : Sequence(l,a,n) {

  int mL = getMaxLength();
  backbone = new Coordinate3D* [mL];

  return;
}


// Constructor
Structure::Structure(int l, Alphabet* a)
  : Sequence(l,a) {

  int mL = getMaxLength();
  //printf("mL: %d\n",mL);
  backbone = new Coordinate3D* [mL];

  return;
}


// Destructor
Structure::~Structure() {

  for (int i=0; i<getLength(); i++) {
    delete backbone[i];
  }

  delete backbone;

  return;
}


// addSymbol - overrides method in symbolList
int Structure::addSymbol(Symbol* symbol) {

  if (getLength() == getMaxLength()) {
    return 0;   // false
  }

  backbone[getLength()] = 0;
  Sequence::addSymbol(symbol);

  return 1;
}


// addSymbol - overrides method in symbolList
int Structure::addSymbol(char c) {

  if (getLength() == getMaxLength()) {
    return 0;   // false
  }

  backbone[getLength()] = 0;
  Sequence::addSymbol(c);

  return 1;
}


int Structure::addElement(Symbol* symbol, float x, float y, float z) {
  
  if (getLength() == getMaxLength()) {
    return 0;   // false
  }

  backbone[getLength()] = new Coordinate3D(x,y,z);
  Sequence::addSymbol(symbol);
  
  //printf("Adding coordinate(%f,%f,%f)\n",x,y,z);
  return 1;   // true
}


int Structure::addElement(char c, float x, float y, float z) {
  
  if (getLength() == getMaxLength()) {
    return 0;   // false
  }

  backbone[getLength()] = new Coordinate3D(x,y,z);
  Sequence::addSymbol(c);
  
  //printf("Adding coordinate(%f,%f,%f)\n",x,y,z);

  return 1;   // true
}


int Structure::addElement(Symbol* symbol, Coordinate3D* coord) {
  
  if (getLength() == getMaxLength()) {
    return 0;   // false
  }

  if (coord != 0) {
    backbone[getLength()] = new Coordinate3D(coord->getX(),coord->getY(),coord->getZ());
  }
  else {
    backbone[getLength()] = 0;
  }
  Sequence::addSymbol(symbol);

  return 1;
}


Coordinate3D* Structure::getCoordinate(int i) {
  
  //printf("=>Structure::getCoordinate(%d)\n",i);

  if (i < getLength()) {
    //printf("=>Structure::getCoordinate() success\n");
    return backbone[i];
  }

  //printf("=>Structure::getCoordinate()\n");
  return 0;
}
