
#ifndef STRUCTURE_H
#define STRUCTURE_H

#include "alphabet.h"
#include "coordinate3D.h"
#include "sequence.h"

class Structure : public Sequence {

 public:
  Structure(int l, Alphabet* a, char* n);
  Structure(int l, Alphabet* a);
  ~Structure();

  int addSymbol(Symbol* symbol);
  int addSymbol(char c);
  int addElement(Symbol* symbol, float x, float y, float z);
  int addElement(char c, float x, float y, float z);
  int addElement(Symbol* symbol, Coordinate3D* coord);
  Coordinate3D* getCoordinate(int i);

 private:
  Coordinate3D** backbone;

};

#endif
