set packagePath "packagePath"

lappend ::auto_path $packagePath
package require RosettaVMD

#NAMD, PSF input files
# set topdir "/Users/maximilianscheurer/Dropbox/#classicMS/all_solvate/par"
set topdir "$packagePath"
set topfile1 top_all36_prot.rtf
set topfile2 top_all36_water_ions.rtf
set topfiles [list $topfile1 $topfile2]

set parfile1 par_all36_prot.prm
set parfile2 par_all36_water_ions.prm
set parfiles [list $parfile1 $parfile2]

# NAMD PATH
# set path "/Users/maximilianscheurer/Documents/MD/namd/"
set path "namdPath"
# set namdArgs "+p4" ;# all additional NAMD arguments, e.g. +pN +setcpuaffinity
set namdArgs "+p4"

# set vmdexe "/Applications/VMD\ 1.9.2.app/Contents/vmd/vmd_MACOSXX86"
set vmdexe "/usr/local/bin/vmd"
set gnuplotexe "/usr/bin/gnuplot"
# Rosetta path
set rosettapath "rosettapath"
set rosettaDBpath "rosettaDBpath"
set platform "linuxgccrelease" ;# or "linuxgccrelease"

#### Custom config ####
set nstruct 1
set bestN 1
set ch_seg [list {"rpn11" "A" "AP1"}]
set mutations {}
puts $ch_seg
set dcdfreq 200

### highres
start_rosetta_refine step1 rpn11_human_27-310_fit [list "resid 164 to 184" "resid 222 to 242" "resid 266 to 280" "resid 296 to 310"] 1 1 rpn11_human_27-310_emd4002_3_3.9_density 3.9 -0.1 $bestN 1
start_mdff_run step1 rpn11_human_27-310_fit rpn11_human_27-310_emd4002_3_3.9_density "not (resid 164 to 184 or resid 222 to 242 or resid 266 to 280 or resid 296 to 310)" 0.6 400 20000 3.9 $bestN


start_rosetta_refine step2 step1_rpn11_human_27-310_fit_best1-mdff [list "resid 164 to 184" "resid 222 to 242" "resid 266 to 280" "resid 300 to 310"] 1 0 rpn11_human_27-310_emd4002_3_3.9_density 3.9 0.0 $bestN 1
start_mdff_run step2 step1_rpn11_human_27-310_fit_best1-mdff rpn11_human_27-310_emd4002_3_3.9_density "not (resid 164 to 184 or resid 222 to 242 or resid 266 to 280 or resid 296 to 310)" 1.0 400 20000 3.9 $bestN

set longname step2_step1_rpn11_human_27-310_fit_best1-mdff_best1-mdff
set shortname rpn11_human_27-310_bb_refined

exec cp full_length_model/$longname.pdb full_length_model/$shortname.pdb
/home/max/Dropbox/tutorial/test
start_rosetta_refine_sidechains_density step3 $shortname [list "all"] 1 rpn11_human_27-310_emd4002_3_3.9_density 3.9 0.1 $bestN $nstruct
start_mdff_run step3 $shortname rpn11_human_27-310_emd4002_3_3.9_density "none" 1.0 400 10000 3.9 $bestN 1

quit
