set packagePath "packagePath"
lappend ::auto_path $packagePath
package require RosettaVMD

#NAMD, PSF input files
set topdir "topdir"
set topfile1 topfile1
set topfiles [list $topfile1]

set parfile1 parfile1
set parfiles [list $parfile1]

# NAMD PATH
# set path "/Users/maximilianscheurer/Documents/MD/namd/"
set path "namdpath"
# set namdArgs "+p4" ;# all additional NAMD arguments, e.g. +pN +setcpuaffinity
set namdArgs "+p8"

set vmdexe "/usr/local/bin/vmd"
set gnuplotexe "/usr/bin/gnuplot"
# Rosetta path
set rosettapath "rosettapath"
set rosettaDBpath "rosettaDBpath"
set platform "linuxgccrelease" ;# or "linuxgccrelease"

#### Custom config ####
set nstruct 1
set bestN 1
set ch_seg [list {"rpn11" "A" "AP1"}]
set mutations {}
puts $ch_seg
set dcdfreq 200


# generate mrc density file for Rosetta
make_mrc_file rpn11_model_5_2594_density

start_rosetta_refine rpn11_midres_bb rpn11_yeast [list "resid 212 to 228" "resid 296 to 306"] 1 1 rpn11_model_5_2594_density 7.7 -0.3 $bestN $nstruct
start_mdff_run rpn11_midres_bb rpn11_yeast rpn11_model_5_2594_density "not (resid 212 to 228 or resid 296 to 306)" 0.6 400 20000 7.7 $bestN

quit
