set packagePath "packagePath"
lappend ::auto_path $packagePath
package require RosettaVMD

set MOL rpn11_yeast_3jck  
set cutoff 2
set EMDB_ID 6479  

mol new $MOL.pdb
set sel [atomselect top all] 

make_dx_file emdb_6479

volmap mask $sel -o mask.dx -cutoff $cutoff 
volutil -mult emdb_${EMDB_ID}.dx mask.dx -o ${MOL}_${cutoff}_${EMDB_ID}_density.dx

make_mrc_file ${MOL}_${cutoff}_${EMDB_ID}_density

quit 
