#!/bin/bash
	JOBNAME="${1/%}"
	MOL="${2/%}"
	if [ -z "$1" ]; then
  		echo Need job name!
  		exit
	fi
	/home/max/Downloads/rosetta_src_2016.20.58704_bundle/main/source/bin/rosetta_scripts.linuxgccrelease \
			-database /home/max/Downloads/rosetta_src_2016.20.58704_bundle/main/database \
			-nstruct 1 \
		-parser::script_vars denswt=25 rms=1.5 reso=3.9 map=../rosetta_input_step3/rpn11_human_27-310_emd4002_3_3.9_density.mrc testmap=../rosetta_input_step3/rpn11_human_27-310_emd4002_3_3.9_density.mrc \
		-edensity::mapreso 3.9 \
	        -out::prefix ${JOBNAME}_ \
		-s ../full_length_model/${MOL} \
	        -parser::protocol ../rosetta_input_step3/step3.xml \
	        -parser:view \
	        -overwrite \
	        -ignore_zero_occupancy false

	mv ${JOBNAME}*.pdb ./pdb_out/
	mv *.sc ./sc_out/
	
