#### General config ####
set packagePath "packagePath"
lappend ::auto_path $packagePath
package require RosettaVMD

set vmdexe "vmdexe"
set gnuplotexe "/opt/local/bin/gnuplot"
# Rosetta path
set rosettapath "/rosettapath"
set rosettaDBpath "rosettaDBpath"
set platform "linuxgccrelease" ;# or "linuxgccrelease"

#### Custom config ####
set nstruct 100
set bestN 100

# Rosetta Template Path for Rigid Chunk
set tempPath [pwd]/full_length_model
# template directory for alignment in analyze_abinitio
set tempdir [pwd]/full_length_model

set comps [list [list ss 138 157 "A"] [list cluster 138 157 "A" 2]]

start_rosetta_insertion rpn11_insertion rpn11_yeast_23-306_complete [list "resid 138 to 157"] [list "rpn11_yeast_23-306_frag9" "rpn11_yeast_23-306_frag3"] [pwd]/input rpn11_yeast_23-306 $nstruct
# analyze_abinitio jobname mol bestN nstruct cluster align_template align_rosetta analysis_components
analyze_abinitio "rpn11_insertion" "rpn11_yeast_23-306_complete_S" $bestN $nstruct 0 "resid 1 to 137 or resid 158 to 284" "resid 1 to 137 or resid 158 to 284" $comps "rpn11_yeast_23-306_complete"

quit
